<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_GET['product_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Product ID is required']);
    exit;
}

$product_id = intval($_GET['product_id']);

try {
    // Get all available serial numbers for the product
    $stmt = $pdo->prepare("
        SELECT serial_number 
        FROM product_serial_numbers 
        WHERE product_id = ? AND status = 'available' 
        ORDER BY created_at ASC
    ");
    $stmt->execute([$product_id]);
    $serial_numbers = $stmt->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode([
        'success' => true,
        'serial_numbers' => $serial_numbers
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Failed to fetch serial numbers',
        'message' => $e->getMessage()
    ]);
} 